/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.content;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.content.IVWContentViewMouseListener;
import filenet.vw.toolkit.admin.content.VWConfigContentViewPane;
import filenet.vw.toolkit.admin.content.VWConfigIcon;
import filenet.vw.toolkit.admin.content.VWContentViewMouseAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

class VWConfigPropertyViewPane
extends JPanel
implements IVWContentViewMouseListener {
    private VWContentViewMouseAdapter m_contentViewMouseAdapter = null;
    private ActionListener m_actionListener = null;

    public VWConfigPropertyViewPane(VWConfigContentViewPane contentPane, VWConfigBaseNode node, ActionListener listener) {
        try {
            this.setLayout(new FlowLayout(3));
            this.setBackground(Color.white);
            Dimension dim = VWStringUtils.stringToDimension("665,385");
            if (dim == null) {
                dim = new Dimension(600, 350);
            }
            this.setPreferredSize(dim);
            this.m_contentViewMouseAdapter = new VWContentViewMouseAdapter(contentPane, this, node.getSessionInfo());
            this.m_actionListener = listener;
            this.displayContent(node);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayContent(VWConfigBaseNode node) {
        this.removeAll();
        int nodeType = node.getType();
        if ((nodeType & 0x10) > 0) {
            if (nodeType == 19 && ((VWConfigRegionNode)node).getSessionInfo() == null) {
                this.add(this.makeButton(node, 0, 3));
            } else {
                int childCount = node.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    VWConfigBaseNode obj = (VWConfigBaseNode)node.getChildAt(i);
                    this.add(this.makeButton(obj, 0, 3));
                }
            }
        } else {
            this.add(this.makeButton(node, 0, 3));
        }
        this.revalidate();
        this.repaint();
    }

    protected void releaseResources() {
        if (this.m_contentViewMouseAdapter != null) {
            this.m_contentViewMouseAdapter.releaseResources();
            this.m_contentViewMouseAdapter = null;
        }
        this.m_actionListener = null;
    }

    private VWConfigIcon makeButton(VWConfigBaseNode node, int hPosition, int vPosition) {
        VWConfigIcon b = new VWConfigIcon(node);
        b.setHorizontalTextPosition(hPosition);
        b.setVerticalTextPosition(vPosition);
        b.setToolTipText(node.getActionCommandString());
        b.setActionCommand(node.getActionCommandString());
        b.addMouseListener(this.m_contentViewMouseAdapter);
        b.addActionListener(this.m_actionListener);
        return b;
    }
}

